macroScript morovash category:"SGX Morovash" internalcategory:"Morovash" buttonText:"Morovash" tooltip:"Morovash: Flickerless Rendering" icon:#("SGX-Morovash",1)
(
	--local isOpen=false
	--morovashFloater = newRolloutFloater "Morovash v" 180 255
	
	
--about init
global moroVersion="0.40a",
moroSeason="2016",
moroAuthor="Sylkun GraphX",
moroContact="Sylkun.GraphX live.fr",
--actions init
abortRendering=false,
pauseRendering=false,
--lists init
moroSelZero=1,
moroSelRewind=1,
moroSelAlert=1,
--options init
moroSceneRedraw=false,-- logsystem.quietmode=true
--leading init
moroFzero=1,
--time init
moroPreviousMsec=0,-- moroPreviousSec=0,
--fn init
moroRefresh
local moroRendering
--------




rollout morovashRenderRO "Rendering" width:180 height:0
(
	button btnRender "Render" pos:[12+4,34-20] width:138 height:26 enabled:false toolTip:"Start Rendering\n(Escape to abort - Shift to pause)"
	progressBar pbProgress "" pos:[-1+4,20-20] width:163 height:52 value:0 color:(color 255 0 0)
	GroupBox grpProgress "Progress" pos:[-1+5,91-20] width:163 height:80
	dotNetControl lblpbStart "System.Windows.Forms.Label" pos:[3+3,74-20] width:50 height:12
	dotNetControl lblpbEnd "System.Windows.Forms.Label" pos:[110+3,74-20] width:50 height:12
	dotNetControl lblpbCurrent "System.Windows.Forms.Label" pos:[53+3,74-20] width:57 height:12
	label lblCF "-" pos:[6+5,113-20] width:150 height:15
	label lbl1 "Elapsed Time:" pos:[6+5,135-20] width:75 height:14 enabled:true
	label lblEL "--" pos:[82+5,135-20] width:78 height:14 enabled:true
	label lbl2 "Remaining:" pos:[6+5,153-20] width:75 height:15 enabled:true
	label lblES "--" pos:[82+5,153-20] width:78 height:14 enabled:true
	
	Timer delay "DL" pos:[6,200] width:24 height:24 interval:10 active:false
	Timer antiParkinson "AP" pos:[132,200] width:24 height:24 interval:10 active:true

	on btnRender pressed do (
		btnRender.enabled= off
		btnRender.visible= off
		delay.active=on
	)
	on antiParkinson tick do (
		antiParkinson.active= off
		antiParkinson.interval=1000
		btnRender.visible= on
		btnRender.enabled= on
		lblpbCurrent.text= "Ready"
	)
	on delay tick do (
		delay.active= off
		moroRendering()
	)
	on morovashRenderRO open do ()
)

rollout morovashOutputRO "Output" width:162 height:0
(
	checkbox chkSaveFiles "Save Files" pos:[6,6] width:70 height:16 checked:rendSaveFile
	button btnBrowse "..." pos:[6,27] width:16 height:16 enabled:on toolTip:"Browse Output Base Filename..."
	label lblOutput "" pos:[22,27] width:134 height:16 style_sunkenedge:true
	checkButton chkbtnRenderSetup "Setup" pos:[130,49] width:26 height:26 enabled:on toolTip:"Render Setup Dialog..."
	checkbox chkLockName "ReUse Base Name" pos:[6,49] width:108 height:16 checked:true
	dropdownList ddlZero "Leading Zeros:" pos:[5,72] width:152 height:40 items:#("Time Based (001-xxx)", "Range Based (01-xx)", "Zero Zero (1-xxx)")

	on ddlZero selected sel do moroSelZero=sel
	on btnBrowse pressed do (
		rof= selectSaveBitMap caption:"Render Output File" filename:rendOutputFilename gamma:&gma
		if rof!=undefined do (
			rendOutputFilename=rof
			renderSceneDialog.update()
			moroRefresh()
		)
	)
	on chkbtnRenderSetup changed state do if state then (max render scene; tabbedDialogs.setCurrentPage #render 1) else tabbedDialogs.closeDialog #render
	on chkSaveFiles changed state do (
		moroRefresh()
		rendSaveFile=state
		renderSceneDialog.update()
	)
-- 	on morovashOutputRO rolledUp state do (
-- 		try(cui.unRegisterDialogBar morovashFloater)catch()
-- 		try(roHeight= morovashOutputRO.height+5;)catch()
-- 		try(morovashFloater.size.y+= if state then roHeight else -roHeight)catch()
-- 		try(cui.RegisterDialogBar morovashFloater)catch()
-- 	)
)

rollout morovashOptionsRO "Options" width:162 height:0
(
	checkbox chkRedraw "Scene Redraw" pos:[6,6] width:90 height:16 checked:moroSceneRedraw tooltip:"Allow viewport live redraw while rendering"
	checkbox chkDegrade "Degrade to" pos:[6,25] width:75 height:16 checked:true enabled:moroSceneRedraw tooltip:"Allow viewport degradation while rendering"
	radioButtons radDeg "" pos:[81,25] width:1 height:16 labels:#("Wire","Box") enabled:off tooltip:"viewport render level"
	dropdownList ddlRewind "AutoRewind:" pos:[5,45] width:152 height:40 items:#("To First Frame of Range", "To First Frame of Time", "Stay on Last Rendered")
	dropdownList ddlAlert "Render Termination Alert:" pos:[5,89] width:152 height:40 items:#("Preference Settings", "Send eMail", "Beep", "Play Sound", "Just Shut Up")

	on chkDegrade changed state do radDeg.enabled=state
	on chkRedraw changed state do (
		moroSceneRedraw=state
		chkDegrade.enabled=state
		radDeg.enabled=(chkDegrade.enabled and chkDegrade.checked)
	)
	on ddlRewind selected sel do moroSelRewind=sel
	on ddlAlert selected sel do (
		moroSelAlert=sel
	)
-- 	on morovashOptionsRO rolledUp state do (
-- 		try(cui.unRegisterDialogBar morovashFloater)catch()
-- 		try(roHeight= morovashOptionsRO.height+5;)catch()
-- 		try(morovashFloater.size.y+= if state then roHeight else -roHeight)catch()
-- 		try(cui.RegisterDialogBar morovashFloater)catch()
-- 	)
	
	on morovashOptionsRO open do (
		alignDn= for i in (getPropNames morovashRenderRO.lblpbEnd.TextAlign) collect i as string
		morovashRenderRO.lblpbStart.TextAlign= (getProperty morovashRenderRO.lblpbEnd.TextAlign alignDn[5])
		morovashRenderRO.lblpbEnd.TextAlign= (getProperty morovashRenderRO.lblpbEnd.TextAlign alignDn[6])
		morovashRenderRO.lblpbCurrent.TextAlign= (getProperty morovashRenderRO.lblpbEnd.TextAlign alignDn[4])

		radDeg.enabled=(chkDegrade.enabled and chkDegrade.checked)
		
		moroRefresh()
	)
)

rollout morovashPauseDialog "Morovash: Pause Options" width:162 height:0
(
	checkbox chkRedraw "Scene Redraw" pos:[6,6] width:90 height:16 checked:moroSceneRedraw tooltip:"Viewport redraw while rendering"
	checkbox chkDegrade "Degrade to" pos:[6,25] width:75 height:16 checked:true enabled:moroSceneRedraw tooltip:"Viewport degradation while rendering"
	radioButtons radDeg "" pos:[81,25] width:1 height:16 labels:#("Wire","Box") enabled:off tooltip:"Viewport render level"
	dropdownList ddlRewind "AutoRewind:" pos:[5,45] width:152 height:40 items:#("To First Frame of Range", "To First Frame of Time", "Stay on Last Rendered")
	dropdownList ddlAlert "Render Termination Alert:" pos:[5,89] width:152 height:40 items:#("Preference Settings", "Send eMail", "Beep", "Play Sound", "Just Shut Up")

	button btnResumeRendering "Resume Rendering" offset:[0,-1]
	button btnAbortRendering "Abort Rendering" offset:[0,1]
	
	on chkDegrade changed state do radDeg.enabled=state
	on chkRedraw changed state do (
		chkDegrade.enabled=state
		radDeg.enabled=(chkDegrade.enabled and chkDegrade.checked)
	)
	on ddlRewind selected sel do moroSelRewind=sel
	on ddlAlert selected sel do (
		moroSelAlert=sel
	)
	on btnResumeRendering pressed do (
		moroSceneRedraw=chkRedraw.checked
		morovashOptionsRO.chkRedraw.checked=moroSceneRedraw
		morovashOptionsRO.chkDegrade.enabled=moroSceneRedraw
		morovashOptionsRO.radDeg.enabled=(chkDegrade.enabled and chkDegrade.checked)
		morovashOptionsRO.radDeg.state=radDeg.state
		if moroSceneRedraw then enableSceneRedraw() else disableSceneRedraw()
		if (chkDegrade.checked and moroSceneRedraw) then (if radDeg.state==1 then viewport.SetRenderLevel #wireFrame else viewport.SetRenderLevel #Box)
		destroyDialog morovashPauseDialog
		
	)
	on btnAbortRendering pressed do (
		abortRendering=true
		destroyDialog morovashPauseDialog
	)
	on morovashPauseDialog open do (
		chkRedraw.checked=moroSceneRedraw
		chkDegrade.enabled=moroSceneRedraw
		chkDegrade.checked=morovashOptionsRO.chkDegrade.checked
		radDeg.enabled=(chkDegrade.enabled and chkDegrade.checked)
		--moroRefresh()
	)
)

fn moroRefresh =(
	renderSceneDialog.commit()
	global justFilename= "\\" +filenameFromPath rendOutputFilename

	global fTimeEnd= trimright (animationRange.end as string) "f"
	global fStart= trimright (rendStart as string) "f"
	global fEnd= trimright (rendEnd as string) "f"
	if (fEnd as integer) > (fTimeEnd as integer) then fEnd= fTimeEnd
	case moroSelZero of (
		2: moroFzero= fEnd.count
		3: moroFzero= 1
		default: moroFzero= fTimeEnd.count
	)
	morovashOutputRO.lblOutput.caption= justFilename
	morovashRenderRO.lblpbStart.text= fStart
	morovashRenderRO.lblpbEnd.text= fEnd
	
	fStart= fStart as integer
	fEnd= fEnd as integer
	global fCount= fEnd-fStart+1
)

rollout morovashAboutRO "Morovash" width:162 height:0
(
	label lblVersion "Morovash antiFlick v" height:15 align:#center
	label lblAuthor "-" height:15 align:#center

	on morovashAboutRO open do (
		lblVersion.caption+= moroVersion
		lblAuthor.caption= ""+moroSeason+" "+moroAuthor
	)
)

fn moroTimeToString ms =(		-- (timeStamp converter) convert milliseconds to days, hours, min, seconds, ms and return formatted string "0d 00:00:00" or "00:00:00" if days=0
	s=0;m=0;h=0;d=0
	if ms>=1000 do(s=ms/1000;ms=ms-(s*1000);if s>=60 do(m=s/60;s=s-(m*60);if m>=60 do(h=m/60;m=m-(h*60);if h>=24 do(d=h/24;h=h-(d*24)))))
	dhmsm= (if d!=0 then d as string +"d " else "") as string +formattedPrint h format:"02u:" +formattedPrint m format:"02u:" +formattedPrint s format:"02u." +formattedPrint ms format:"03u"
)

fn moroChrono starttime totalpause lastpause remainingframes =(
	current=timeStamp() as integer
	morovashRenderRO.lblES.caption= moroTimeToString ((timeStamp() - moroPreviousMsec) * remainingframes)		-- REMAINING COUNTER
	morovashRenderRO.lblEL.caption= moroTimeToString (current - starttime - totalpause)		-- ELASPED COUNTER
	moroPreviousSec=current
	moroPreviousMsec=timeStamp()
)

fn moroRendering =(
	renderSceneDialog.commit()
	file= rendOutputFilename
	initialfilename= file

	if (file!= "") and (file!= undefined) then (
		morovashRenderRO.lblEL.caption= "00:00:00.000"
		morovashRenderRO.lblES.caption= "00:00:00.000"
		morovashRenderRO.btnRender.enabled= off
		fpath= getFilenamePath file
		fname= getFilenameFile file +"_"
		ftype= getFilenameType file

		sliderTime= rendStart
		rendTimeType= 1
		renderSceneDialog.update()
		moroRefresh()

		renderlevel=case of (
			(NitrousGraphicsManager.IsEnabled()): (rl=NitrousGraphicsManager.GetActiveViewportSetting(); rl.VisualStyleMode)
			default: viewport.GetRenderLevel()
		)

		if (morovashOptionsRO.chkDegrade.checked) and (moroSceneRedraw) then (if morovashOptionsRO.radDeg.state==1 then viewport.SetRenderLevel #wireFrame else viewport.SetRenderLevel #Box)
		if moroSceneRedraw then enableSceneRedraw() else disableSceneRedraw()

		moroPreviousMsec=timeStamp()
		starttime= moroPreviousMsec as integer -- init Start Time
		totalpause=0 -- init total duration of pause
		lastpause=0 -- init duration of the last pause

		for f=fStart to fEnd while (not abortRendering) do (
			
			if keyboard.shiftPressed do ( -- Hold SHIFT to Pause Rendering
				pauseup= timeStamp()
				morovashRenderRO.lblpbCurrent.text= "Paused"

				createDialog morovashPauseDialog width:320 height:180 modal:true

				lastpause= timeStamp()-pauseup
				totalpause+= lastpause as integer
			)
			case of (
				(keyboard.escPressed): abortRendering=true -- Hold ESCAPE to Abort Rendering
				(not abortRendering):( -- RENDERING
					morovashRenderRO.lblpbCurrent.text= f as string
					curfilename= fname+formattedPrint f format:("0"+moroFzero as string+"u")
					rendOutputFilename= fpath+curfilename+ftype
					renderSceneDialog.update()
					morovashRenderRO.lblCF.caption= curfilename

					pbv=case of ((fCount!=1):(100*(f-fStart+1)/(fCount)) as integer
						default:100
					)
					morovashRenderRO.pbProgress.value= pbv
					case of ((pbv<50):(cR=255; cG=0; cB=(pbv*5.1) as integer)
						default:(cR=255-((pbv-50)*5.1) as integer; cG=((pbv-50)*5.1) as integer; cB=255)
					)
					morovashRenderRO.pbProgress.color= (color cR cG cB)
					
					if f!=fStart then sliderTime += 1
					max quick render
					
					remainingframes= fCount - (f-fStart+1)
					moroChrono starttime totalpause lastpause remainingframes
				)
			)
		)

		morovashRenderRO.pbProgress.color= (color 0 255 0)
		morovashRenderRO.lblpbCurrent.text= if abortRendering then "Aborted" else "Done"
		abortRendering=false
		
		if morovashOutputRO.chkLockName.checked then (
			morovashOutputRO.lblOutput.caption= "\\" +filenameFromPath initialfilename
			rendOutputFilename=initialfilename
		) else morovashOutputRO.lblOutput.caption= "\\" +filenameFromPath rendOutputFilename
		
		case moroSelRewind of (
			1: sliderTime= fStart
			2: sliderTime= 0
		)
		renderSceneDialog.update()
		
		morovashRenderRO.antiParkinson.active= on
		enableSceneRedraw()
		case of (
			(NitrousGraphicsManager.IsEnabled()): rl.VisualStyleMode= renderlevel
			default: viewport.SetRenderLevel renderlevel
		)

		) else (
		morovashRenderRO.btnRender.enabled= on
		morovashRenderRO.btnRender.visible= on
	)
)
morovashFloater = newRolloutFloater "Morovash v" 180 255
addRollout morovashRenderRO morovashFloater border:false offset:[20,20]
addRollout morovashOutputRO morovashFloater border:true rolledUp:true
addRollout morovashOptionsRO morovashFloater border:true rolledUp:true
addRollout morovashAboutRO morovashFloater border:false
morovashFloater.title+=moroVersion
cui.RegisterDialogBar morovashFloater
)
